;**********************************************************************																																																																			;**********************************************************************
;   This file is a basic code template file for assembly code         *
;   generation for the PIC16C771. This file contains the              *
;   basic code building blocks to build upon.                         *  
;                                                                     *
;   If interrupts are not used all code presented between the ORG     *
;   0x004 directive and the label main can be removed. In addition    *
;   the variable assignments for 'w_temp' and 'status_temp' can       *
;   be removed.                                                       *                            
;                                                                     *
;   Refer to the MPASM User's Guide for additional information on     *
;   features of the assembler (Document DS33014).                     *
;                                                                     *
;   Refer to the respective PIC data sheet for additional            *
;   information on the instruction set.                               *
;                                                                     *
;   Template file assembled with MPLAB V4.12.05 and MPASM V2.30.00.   *
;                                                                     *
;**********************************************************************
;                                                                     *
;    Filename:	    xxx.asm                                           *
;    Date:                                                            *
;    File Version:                                                    *
;                                                                     *
;    Author:                                                          *
;    Company:                                                         *
;                                                                     * 
;                                                                     *
;**********************************************************************
;                                                                     *
;    Files required:                                                  *
;                                                                     *
;                                                                     *
;                                                                     *
;**********************************************************************
;                                                                     *
;    Notes:                                                           *
;                                                                     *
;                                                                     *
;                                                                     *
;                                                                     *
;**********************************************************************


	list      p=16c771            ; list directive to define processor
	#include <p16c771.inc>        ; processor specific variable definitions
	
	__CONFIG   _CP_OFF & _WDT_ON & _BODEN_ON & _PWRTE_ON & _VBOR_25 & _ER_OSC_CLKOUT
; '__CONFIG' directive is used to embed configuration data within .asm file.
; The labels following the directive are located in the respective .inc file.
; See respective data sheet for additional information on configuration word.





;***** VARIABLE DEFINITIONS

count         EQU     0x20        ; temporary variable (example)

w_temp        EQU     0x70        ; variable used for context saving 
status_temp   EQU     0x71        ; variable used for context saving





;**********************************************************************
		ORG    0x000              ; processor reset vector
		movlw  high  start        ; load upper byte of 'start' label
		movwf  PCLATH             ; initialize PCLATH
	 	goto   start              ; go to beginning of program


		ORG     0x004             ; interrupt vector location
		movwf   w_temp            ; save off current W register contents
		movf	STATUS,w          ; move status register into W register
		movwf	status_temp       ; save off contents of STATUS register


; isr code can go here or be located as a call subroutine elsewhere


		movf    status_temp,w     ; retrieve copy of STATUS register
		movwf	STATUS            ; restore pre-isr STATUS register contents
		swapf   w_temp,f
		swapf   w_temp,w          ; restore pre-isr W register contents
		retfie                    ; return from interrupt


start

		nop                       ; code starts here (example)
		banksel  count            ; example
		clrf   count              ; example

; remaining code goes here






		END                       ; directive 'end of program'

